﻿<!-----------------------------------------------------------------------
********************************************************************************
Copyright Since 2005 ColdBox Framework by Luis Majano and Ortus Solutions, Corp
www.coldbox.org | www.luismajano.com | www.ortussolutions.com
********************************************************************************

Author: Luis Majano
Date:   September 27, 2005
Description: This is the framework's logger object. It performs all necessary
			 loggin procedures.
----------------------------------------------------------------------->
<cfcomponent hint="This is the frameworks Logger object. It is used for all logging facilities interfacing with LogBox and the ColdBox debugger."
			 extends="coldbox.system.Plugin"
			 output="false"
			 cache="true">

<!------------------------------------------- CONSTRUCTOR ------------------------------------------->

	<!--- Constructor --->
	<cffunction name="init" access="public" returntype="Logger" hint="Constructor" output="false">
		<cfargument name="controller" type="any" required="true">
		<cfscript>
			super.Init(arguments.controller);
			
			// setup properties
			setpluginName("Logger");
			setpluginVersion("1.1");
			setpluginDescription("This plugin is used for logging methods and facilities interfacing to LogBox.");
			setpluginAuthor("Luis Majano");
			setpluginAuthorURL("http://www.coldbox.org");
			
			// Set local Logger for this ColdBox Application, different from the local Log object.
			instance.logger = logBox.getLogger(getSetting("AppName"));
			
			return this;
		</cfscript>
	</cffunction>

<!------------------------------------------- PUBLIC ------------------------------------------->
	
	<!--- getLogger --->
	<cffunction name="getLogger" output="false" access="public" returntype="coldbox.system.logging.Logger" hint="This coldbox apps's logger.">
		<cfreturn instance.logger>
	</cffunction>
	
	<!--- Debug --->
	<cffunction name="debug" access="public" output="false" returntype="void" hint="I log a debug message.">
		<cfargument name="message"   type="string" 	required="true" hint="The message to log.">
		<cfargument name="extraInfo" type="any" 	required="false" default="" hint="Extra information to append.">
		<cfscript>
			getLogger().debug(argumentCollection=arguments);
		</cfscript>
	</cffunction>
	
	<!--- Info --->
	<cffunction name="info" access="public" output="false" returntype="void" hint="I log an information message.">
		<cfargument name="message"   type="string" 	required="true" hint="The message to log.">
		<cfargument name="extraInfo" type="any" 	required="false" default="" hint="Extra information to append.">
		<cfscript>
			getLogger().info(argumentCollection=arguments);
		</cfscript>
	</cffunction>
	
	<!--- warn --->
	<cffunction name="warn" access="public" output="false" returntype="void" hint="I log a warning message.">
		<cfargument name="message"   type="string" 	required="true" hint="The message to log.">
		<cfargument name="extraInfo" type="any" 	required="false" default="" hint="Extra information to append.">
		<cfscript>
			getLogger().warn(argumentCollection=arguments);
		</cfscript>
	</cffunction>
	
	<!--- Error --->
	<cffunction name="error" access="public" output="false" returntype="void" hint="I log an error message.">
		<cfargument name="message"   type="string" 	required="true" hint="The message to log.">
		<cfargument name="extraInfo" type="any" 	required="false" default="" hint="Extra information to append.">
		<cfscript>
			getLogger().error(argumentCollection=arguments);
		</cfscript>
	</cffunction>
	
	<!--- Fatal --->
	<cffunction name="fatal" access="public" output="false" returntype="void" hint="I log a fatal message.">
		<cfargument name="message"   type="string" 	required="true" hint="The message to log.">
		<cfargument name="extraInfo" type="any" 	required="false" default="" hint="Extra information to append.">
		<cfscript>
			getLogger().fatal(argumentCollection=arguments);
		</cfscript>
	</cffunction>

	<!--- Tracer --->
	<cffunction name="tracer" access="public" hint="Log a trace message to the ColdBox debugger panel, not LOGBOX" output="false" returntype="void">
		<cfargument name="message"   type="string" 	required="true" hint="The message to log.">
		<cfargument name="extraInfo" type="any" 	required="false" default="" hint="Extra information to append.">
		<cfscript>
			controller.getDebuggerService().pushTracer(argumentCollection=arguments);
		</cfscript>
	</cffunction>

	<!--- Log Error with exception Bean --->
	<cffunction name="logErrorWithBean" access="public" hint="Log an error into the framework using a coldbox exceptionBean" output="false" returntype="void">
		<cfargument name="exceptionBean" 	type="any" 	required="true" hint="This is the exception bean">
		<cfscript>
			var exception = arguments.exceptionBean;
			var buffer = "";
			
			// Prepare log
			if ( isStruct(exception.getExceptionStruct()) ){
				// Prepare String Buffer
				buffer = createObject("java","java.lang.StringBuffer").init( exception.getExtraMessage() & chr(13));
				
				if ( exception.getType() neq  "" ){
					buffer.append("CFErrorType=" & exception.getType() & chr(13) );
				}
				if ( exception.getDetail() neq  "" ){
					buffer.append("CFDetails=" & exception.getDetail() & chr(13));
				}
				if ( exception.getMessage() neq "" ){
					buffer.append("CFMessage=" & exception.getMessage() & chr(13));
				}
				if ( exception.getStackTrace() neq "" ){
					buffer.append("CFStackTrace=" & exception.getStackTrace() & chr(13));
				}
				if ( exception.getTagContextAsString() neq "" ){
					buffer.append("CFTagContext=" & exception.getTagContextAsString() & chr(13));
				}
			}
			
			// Log The Entry
			getLogger().error(buffer.toString(), exceptionBean.getExtraInfo());
		</cfscript>
	</cffunction>

	<!--- Log Error Facade --->
	<cffunction name="logError" access="public" hint="Log an error into the framework using arguments. Facade to logErrorWithBean." output="false" returntype="void">
		<!--- ************************************************************* --->
		<cfargument name="message" 			type="string" 	required="true">
		<cfargument name="exceptionStruct" 	type="any"  	required="false" default="#StructNew()#" hint="The CF cfcatch structure.">
		<cfargument name="extraInfo"  		type="any"    	required="false" default="">
		<!--- ************************************************************* --->
		<cfset logErrorWithBean(CreateObject("component","coldbox.system.web.context.ExceptionBean").init(arguments.exceptionStruct,arguments.message,arguments.extraInfo))>
	</cffunction>

	<!--- Log An Entry --->
	<cffunction name="logEntry" access="public" hint="Log a message to the internal logger object. DEPRECATED, Please use other methods." output="false" returntype="void">
		<!--- ************************************************************* --->
		<cfargument name="severity" 		type="string" 	required="true" hint="Severity: fatal,error,warn,info,debug,trace">
		<cfargument name="message" 			type="string"  	required="true" hint="The message to log.">
		<cfargument name="extraInfo"		type="any"   	required="false"  default="" hint="Extra information to append.">
		<!--- ************************************************************* --->
		<cfscript>
			var logLevels = logBox.logLevels;
			
			// Check log levels
			if( NOT logLevels.isLevelValid(logLevels.lookupAsInt(arguments.severity)) ){
				$throw(message="Invalid logging severity: #arguments.severity#",
					   detail="Valid severites are: #logLevels.VALIDLEVELS#",
					   type="Logger.InvalidSeverity");
			}
			
			//Log via logBox
			getLogger().logMessage(arguments.message,logLevels.lookupAsInt(arguments.severity),arguments.extraInfo);
		</cfscript>
	</cffunction>
		
<!------------------------------------------- PRIVATE ------------------------------------------->

</cfcomponent>