﻿/**
********************************************************************************
Copyright Since 2005 ColdBox Framework by Luis Majano and Ortus Solutions, Corp
www.coldbox.org | www.luismajano.com | www.ortussolutions.com
********************************************************************************
Author 	    :	Luis Majano
Description :
	Manage Event Handlers

*/
component serializable="false" accessors="true" extends="coldbox.system.mvc.FrameworkSupertype"{

	// LogBox reference
	property name="logBox";
	// Pre-Configured Log Object
	property name="log";
	// WireBox Reference
	property name="wirebox";
	
	// pre handler only except lists
	this.prehandler_only 		= "";
	this.prehandler_except 		= "";
	// post handler only except lists
	this.posthandler_only 		= "";
	this.posthandler_except 	= "";
	// around handler only except lists
	this.aroundhandler_only 	= "";
	this.aroundHandler_except 	= "";
	// HTTP allowed methods
	this.allowedMethods = structnew();
	
	/**
	* Base Controller
	*/
	function init(required controller){
		// Register Controller
		variables.controller = arguments.controller;
		// Register LogBox
		variables.logBox = arguments.controller.getLogBox();
		// Register Log object
		variables.log = variables.logBox.getLogger( this );
		// Register WireBox
		variables.wireBox = arguments.controller.getWireBox();
		
		return this;
	}
	
	/**
	* Action exists
	*/
	function _actionExists(required action){
		return ( structKeyExists(this, arguments.action) OR structKeyExists(variables, arguments.action) );
	}
	
	/**
	* _privateInvoker for private events
	*/
	function _privateInvoker(required method, required argCollection){
		var action = variables[ arguments.method ];
		var results = action(argumentCollection=argCollection);
		if( !isNull( results ) ){ return results; }
	}
	
}